patches-own [
  cooperate?       ;; polko spolupracuje pi hodnot true
  spolupracoval-minule?   ;; polko spolupracovalo v minulm kole
  score            ;; skre, kumulujc se na zklad interakc (her) mezi sousednmi polky
  color-class      ;; numerick hodnota pro tdu barev polek 1= modr, 2= erven, 3= zelen, 4= lut
]

to setup
  ca
  ask patches [
    ifelse random-float 1.0 < (pocatecni-spoluprace / 100)
      [setup-cooperation true]
      [setup-cooperation false]
    establish-color
  ]
  update-plot
end

to setup-cooperation [value]
  set cooperate? value
  set spolupracoval-minule? value
end

to go
  ask patches [interact]          ;; zahj hru se sousednm polkem
  ask patches [select-strategy]   ;; pijme strategii souseda (s nejvym skre)
  tick
  update-plot
end

to update-plot
  set-current-plot "Frekvence spoluprce/nespoluprce"
  plot-histogram-helper "cc" blue
  plot-histogram-helper "dd" red
  plot-histogram-helper "cd" green
  plot-histogram-helper "dc" yellow
end

to plot-histogram-helper [pen-name color-name]
  set-current-plot-pen pen-name
  histogram [color-class] of patches with [pcolor = color-name]
end

to interact  ;; procedura polek
  let total-cooperaters count neighbors with [cooperate?]  ;; celkov poet soused, kte spolupracovali
  ifelse cooperate?
    [set score total-cooperaters]                   ;; spolupracujc zsk skre podle potu soused, kte tak spolupracovali 
    [set score odmena-za-nespolupraci * total-cooperaters]  ;; nespolupracujc zsk skre mrn nsobku potu soused, kte spolupracovali
                                                    
end

to select-strategy  ;; procedura polek
  set spolupracoval-minule? cooperate?
  set cooperate? [cooperate?] of max-one-of neighbors [score] ;; vyber si strategii (spolupracovat, nespolupracovat)
                                                              ;; podle nejspnjho souseda (s nejvym skre)
  establish-color
end

to establish-color  ;; procedura polek
  ifelse spolupracoval-minule?
    [ifelse cooperate?
      [set pcolor blue
       set color-class 1]
      [set pcolor green
       set color-class 3]
    ]
    [ifelse cooperate?
      [set pcolor yellow
       set color-class 4]
      [set pcolor red
       set color-class 2]
    ]
end


; *** NetLogo 4.0.2 Model Copyright Notice ***
;
; This model was created as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
;
; Copyright 2002 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2002).  NetLogo PD Basic Evolutionary model.
; http://ccl.northwestern.edu/netlogo/models/PDBasicEvolutionary.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2002 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/PDBasicEvolutionary
; for terms of use.
;
; *** End of NetLogo 4.0.2 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
426
10
840
445
50
50
4.0
1
10
1
1
1
0
1
1
1
-50
50
-50
50
1
1
1
ticks

CC-WINDOW
5
459
849
554
Command Center
0

BUTTON
20
42
101
75
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
115
42
192
75
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
2
80
210
113
pocatecni-spoluprace
pocatecni-spoluprace
0
100
21.8
0.1
1
%
HORIZONTAL

TEXTBOX
235
38
426
206
Barevn oznaen hr: \n\n                              Kolo \n                   Minul    Souasn\nModr              S                 S\nerven          N                 N\nZelen             S                 N\nlut                N                 S\n \nS - Spolupracoval \nN- Nespolupracoval
11
0.0
0

SLIDER
1
117
210
150
odmena-za-nespolupraci
odmena-za-nespolupraci
0
3
1.66
0.01
1
x
HORIZONTAL

PLOT
10
218
395
431
Frekvence spoluprce/nespoluprce
Druh hre
Frekvence (%)
1.0
5.0
0.0
1.0
true
false
PENS
"cc" 1.0 1 -13345367 true
"dd" 1.0 1 -2674135 true
"cd" 1.0 1 -10899396 true
"dc" 1.0 1 -1184463 true

@#$#@#$#@
CO TO JE?
---------
Jedno z prominentnch tmat v teorii her je tzv. "Vzovo dilema". Vzovo dilema je pkladem her s nenulovm soutem. Ve hrch s nulovm soutem je celkov skre vech hr rovno nule. Jinmi slovy, hri mohou zvit sv skre jen na kor jinho hre (nap. achy, fotbal, poker --- jedna osoba vdy vyhraje a druh prohraje). Oproti tomu ve hrch se nenulovm soutem nemus bt zven skre jednoho hre vyveno snenm skre jinho. V mnoha situacch s nenulovm soutem me hr zvit sv skre pouze tehdy, kdy ho zv i ostatn. Situace s nenulovm soutem vznikaj tam, kde zdroje nejsou njak omezeny (nap. znalosti, umn, obchod). Vzovo dilema jakoto hra s nenulovm soutem demonstruje konflikt mezi racionlnm chovnm jedince a ziskem z kolektivn spoluprce. 

Klasick vzovo dilema je popsno takto: Dva vzov, kte spolu spchali zloin, jsou vyslchni polici. Vzov spolu nemohou komunikovat a policie vyslch kadho zvl᚝. Oba vzni dostanou stejnou nabdku: "Kdy se pizn a tvj komplic bude mlet, pustme tebe na svobodu a on dostane deset let. Kdy se nepizn ani jeden z vs, dostanete oba jen mal trest na pl roku. Kdy se piznte oba, dostanete pt let."
 
Oba vzni budou uvaovat asi takto -- "Kdy se mj park pizn a j ne, tak dostanu deset let, a kdy se j piznm, tak dostanu pt let. Take kdy se mj park pizn, tak je lep, abych se piznal taky. A kdy se park nepizn, a j se piznm, tak m pust na svobodu. Zatmco kdy se nepiznm, tak dostanu pl roku. Take i kdy se mj park nepizn, tak je pro mne lep se piznat. 

Oba partnei racionln uvauj ve uvedenm zpsobem a piznaj se. V neopakovanm vzov dilematu (hraje se jen jednou) spolu partnei nebudou spolupracovat. Nsledkem toho oba dostanou pt let. Kdyby spolupracovali a nepiznali se, dostali by oba jen pl roku. Racionln chovn vede paradoxn ke spoleensky neefektivnmu vsledku. 


|                                 Tabulka skre
|                                 -------------
|                                  V PARTNER
|                         Spolupracuje    Nespolupracuje
|                         -----------------------------
|       Spolupracujete   |(0.5, 0.5)           (0, 10)
|  VY                    |
|       Nespolupracujete |(10, 0)              (5, 5)
|
|        (x, y) = x: Vae skre, y: skre partnera
|        Poznmka: V tomto ppade znamen ni skre vhodu (jde o roky ve vzen).


V opakovanm vzov dilematu, kde spolu me hrt vce hr vce kol za sebou, je rozloen skre jin.  V tomto modelu jsou hri rozmstni na dvourozmrn mce a v kadm kole hraj se vemi svmi sousedy. Pedpokldme, e vzrst potu spolupracujcch hr povede k proporcionlnmu vzrstu skre kadho spolupracujcho hre. Co je pijateln odhad napklad pro sdlen znalost. Skre nespolupracujcch hr je dno potem spolupracujcch soused nsobenm tzv. faktorem alfa. Mra spoluprce je zvisl na faktoru alfa, kter uruje jak vhodn je nespolupracovat. Kdy budeme pokraovat v pedchozm pkladu, tak to znamen, e nespolupracujc hr m zisk (dan faktorem alfa) ze znalost spolupracujcch a pitom s nimi sv znalosti nesdl. 
V  opakovanm vzov dilematu meme sledovat vvoj kooperativnho chovn. 
Tabulku skre pro jednotliv hry opakovanho vzova dilematu si zjednodume a zobecnme:



|                                 Tabulka skre
|                                 -------------
|                                  V PARTNER
|                         Spolupracuje    Nespolupracuje
|                         -----------------------------
|       Spolupracujete   |(1, 1)           (0, alfa)
|  VY                    |
|       Nespolupracujete |(alfa, 0)        (0, 0)
|
|        (x, y) = x: Vae skre, y: skre partnera
|        Poznmka: V tomto ppade znamen vy skre vhodu.


JAK MODEL OVLDAT
-----------------
Rozhodnte se kolik procent hr (polek) bude spolupracovat na zatku simulace a nastavte POCATECNI-SPOLUPRACE. Pot nastavte ODMENA-ZA-NESPOLUPRACI (co je faktor, kter jsme v pedchozm textu nazvali alfa), skre nespolupracujcch hr bude ureno nsobkem tto hodnoty a potu sousednch spolupracujcch hr. Tato hodnota se me pohybovat v rozsahu 0 a 3. Stisknte tlatko PIPRAV a v grafickm okn se objev modr (spolupracujc) a erven (nespolupracujc) polka pedstavujc jednotliv hre. Stiskem START zahjte a ukonte bh modelu. 

JAK TO FUNGUJE
--------------
V kadm kole kad hr nejprve spot, kolik z jeho osmi soused spolupracuje. Pokud hr sm spolupracuje, tak jeho skre je dno potem spolupracujcch soused. Pokud hr nespolupracuje, tak jeho skre je dno potem spolupracujcch soused nsobenm faktorem ODMENA-ZA-NESPOLUPRACI. 

V ptm kole nastav kad hr do hodnoty spolupracoval-minule? svoji souasnou strategii (spolupracoval = true, nespolupracoval = false). Pro dal kolo zvol hr strategii svho souseda, kter v tomto kole doshlo nejvyho skre. 

Pokud je polko modr, tak tento hr spolupracoval v tomto i v minulm kole.
Pokud je polko erven, tak tento hr nespolupracoval v tomto ani v minulm kole.
Pokud je polko zelen, tak tento hr spolupracoval v tomto, ale nespolupracoval v minulm kole.
Pokud je polko lut, tak tento hr nespolupracoval v tomto, ale spolupracoval v minulm kole.

VIMNTE SI
-----------
Vimnte si jak ODMENA-ZA-NESPOLUPRACI ovlivuje poet hr, kte stabiln spolupracuj (modr) nebo stabiln nespolupracuj (erven). Pi jak hodnot ODMENA-ZA-NESPOLUPRACI bude pro hre lhostejn, zda spolupracuj i nikoliv? Pi jakch hodnotch dochz k dynamickm pechodm mezi vemi barvami a dn z nich nakonec nedominuje (na konci nejsou vichni hri ani mod ani erven)? 

ZKUSTE SI
---------
Zvyujte a sniujte nastaven ODMENA-ZA-NESPOLUPRACI (zatmco model b). Sledujte, jak se mn histogram jednotlivch barev pedstavujcch druhy hr. Zvltn pozornost vnujte modrm a ervenm sloupcm. Je poet stabiln spolupracujcch a nespolupracujcch hr pmo, nebo nepmo mrn zven a snen ODMENA-ZA-NESPOLUPRACI? 

Vimnte si POCATECNI-SPOLUPRACE. Pokud je ODMENA-ZA-NESPOLUPRACI nzk (ni ne 1) a procento spolupracujcch hr je na potku vysok, budou na konci pevldat spolupracujc, nebo nespolupracujc hri? A co kdy je ODMENA-ZA-NESPOLUPRACI vysok? Ovlivuje POCATECNI-SPOLUPRACE vsledn stav modelu? Pokud ano, jak? 

ROZEN MODELU
----------------
Zmte kd programu tak, aby polka (patches) mohla volit sloitj strategie a ne se jen dit podle souseda s nejvym skre. Msto toho si kad polko me pro kad sousedn polko zvl᚝ pamatovat, zda toto polko v minulosti spolupracovalo, a na zklad toho se rozhodnout, zda s tmto sousedem bude spolupracovat i nikoliv. 

Zkuste doplnit nsledujc strategie:
1.  Spolupracuj stle: spolupracuj bez ohledu na to, jak se soused chovali v minulosti. 
2.  To m za to (Tit-for-Tat):  spolupracuj pouze pokud soused v minulosti vdy spolupracoval. Jinak nespolupracuj. 
3.  Tom za to, s odpoutnm (Tit-for-Tat-with-forgiveness): spolupracuj pouze pokud soused v minulm kole spolupracoval.  Jinak nespolupracuj.
4.  Nespolupracuj nikdy: nespolupracuj bez ohledu na to, jak se soused chovali v minulosti. 

Jak jsou spolupracujc a nespolupracujc polka rozmstna? Kter strategie pin nejvy prmrn skre? Za jakch podmnek by tato strategie byla nespn?

Model je nyn naprogramovn tak, e v dsledku nhodnho poad, ve kterm jsou agenti aktivovni, je do chodu modelu zanesen prvek nhody. Zmte model tak, aby se choval ist deterministicky (Rada: Zavete pomocnou promnou, do kter ulote novou strategii hre v prbhu vbru strategi. Teprve a vbr probhne pro vechny hre, ulote do aktuln strategie strategii novou.). 

PODKOVN A ODKAZY
-------------------
Vzovo dilema bylo formulovno Melvinem Drescherem a Merrilem Floodem a pojmenovno Albertem W. Tuckerem.
Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:   Wilensky, U. (2002).  NetLogo PD Basic Evolutionary model.  http://ccl.northwestern.edu/netlogo/models/PDBasicEvolutionary.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace: Copyright 2002 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/PDBasicEvolutionary for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
